/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_wait.c,v 1.55 2006/12/01 13:11:57 bgoglin Exp $";
 
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__sleep.h"

/* TODO: Move all of wait into test? */
int mx__test_common(mx_endpoint_t, mx_request_t *request,
		    mx_status_t *status);

MX_FUNC(mx_return_t)
mx_wait(mx_endpoint_t endpoint,
	mx_request_t * request,
	uint32_t timeout,
	mx_status_t *status,
	uint32_t *result)
{
  MX__MUTEX_LOCK(&endpoint->lock);
  MX__EP_STATS_INC(endpoint, wait);
  mx__luigi(endpoint);
  /* Go through one iteration of mx__test_common to see if the request
     is already done. */
  *result = mx__test_common(endpoint, request, status);
  if (*result == 0) {
    if (MX_THREAD_SAFE || timeout != MX_INFINITE) {
      struct mx__wait_queue wq;
      /* todo: if (*request)->basic.wq, return MX_REQUEST_ALREADY_WAITED */
      (*request)->basic.wq = &wq;
      mx__sleep_on_wait_queue(endpoint, &wq, timeout, &endpoint->wait_waiters, 
			      &endpoint->wait_queue_head);
      (*request)->basic.wq = NULL;
      *result = mx__test_common(endpoint, request, status);
    } else {
      *result = 1;
      while (!mx__test_common(endpoint, request, status))
	mx__luigi(endpoint);
    }
  } else {
    MX__EP_STATS_INC(endpoint, nonblocking_wait);
  }
  MX__MUTEX_UNLOCK(&endpoint->lock);
  return MX_SUCCESS;
}

#ifdef MX_VERSIONED_SYMS
void mx__conv_status_to_v1(mx_status_t *p);

mx_return_t mx_wait_v1(mx_endpoint_t ep, mx_request_t *req, uint32_t timeout,
		       mx_status_t *s, uint32_t *res)
{
  mx_return_t rc;
  rc = mx_wait(ep, req, timeout, s, res);
  mx__conv_status_to_v1(s);
  return rc;
}
__asm__(".symver mx_wait_v1,mx_wait@MX_0.0");

#endif
